
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Feb 03 09:58:57 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RSA_Acceptance_main.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_ECC_Acceptance.h"
#include <stdio.h>

/******** Defines *****/
/******** Enums *****/
/******** Typedefs ****/
/******** Global Data ***/
/***** Private function prototype */

CRYSError_t CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus);

/******** Public Functions **/
void CRYS_ExtApp_ATP_ECC_main(void)
{
  DxUint8_t  Var;
  do
   {  
	   do
	   {
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n\n--[ Ext SEP application ECC Acceptance tests Menu  ]-----------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ With Internal Key Generation -----------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [1] - ECDSA Sign Verify Non integrate                           "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [2] - ECDSA Sign Verify integrate                               "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [3] - Diffe Helman                                              "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [4] - ElGamal Encrypt Decrypt                                   "));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [5] - Export public key and sign/verify                         "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n------ Without Internal Key Generation --------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [6] - ECDSA Sign Verify Non integrate                           "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [7] - ECDSA Sign Verify integrate                               "));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [8] - Diffe Helman                                              "));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [9] - ElGamal Encrypt Decrypt                                   "));
               
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [A] - Export public key and sign/verify                         "));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------"));
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [T] - ALL ECC Acceptance Tests with internal KeyGen             "));	           
               ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [S] - ALL ECC Acceptance Tests w/o internal KeyGen              "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n [Z] - End of tests return to prev menu                          "));
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------\n\n"));

	           scanf("\n%c",&Var);
	           ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Test = %c\n",Var));
	           if (Var<='Z')
	                    break;
	           else
	           {
	                 ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n Error[%d]  Please select '1'-'XX'\n\n",Var));
	           }

	    }while(1);

     
	    switch(Var)
	    {
            case '1': 
				    CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify (TST_INTERNAL_KG);
				    break;
            case '2': 
                    CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify (TST_INTERNAL_KG);
                break;
            case '3': 
                    CRYS_ExtApp_ATP_ECC_DH (TST_INTERNAL_KG);
                break;
            case '4': 
                    CRYS_ExtApp_ATP_ECC_ElGamal_EncDec (TST_INTERNAL_KG);
                break;
            
            case '5': 
                    CRYS_ExtApp_ATP_ECC_ImportExportKeyPair (TST_INTERNAL_KG);
                break;
		  	case '6': 
				    CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify (TST_NO_INTERNAL_KEYGEN);
		        break;
            case '7': 
                    CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify (TST_NO_INTERNAL_KEYGEN);
                break;
            
            case '8': 
                    CRYS_ExtApp_ATP_ECC_DH (TST_NO_INTERNAL_KEYGEN);
                break;
            case '9': 
                    CRYS_ExtApp_ATP_ECC_ElGamal_EncDec (TST_NO_INTERNAL_KEYGEN);
                break;
       
            case 'A': 
                    CRYS_ExtApp_ATP_ECC_ImportExportKeyPair (TST_NO_INTERNAL_KEYGEN);
                break;
		  	case 'T': 
				    CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS (TST_INTERNAL_KG);
				    break;			    	 				       				    								    					       				    				
		  	case 'S': 
				    CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS (TST_NO_INTERNAL_KEYGEN);
				    break;	
	       	case 'Z':
	                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n End of Acceptance ECC tests \n"));
	                break;	              
	       	default:
	              ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n* Error in test selection [%c]\n",Var));
	    }
	       if(Var =='Z')
	       break;       
     }while (1);
}

/*** run all Acceptance tests ********/
/*****************/

CRYSError_t CRYS_ExtApp_ATP_ECC_Acceptance_ALL_TESTS(int TST_KeyGeneration_TestStatus)
{
    CRYSError_t TST_ATP_ECC_Error = TESTPASS;
    
    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_ECDSA_NonIntegratedSignVerify (TST_KeyGeneration_TestStatus);
    TST_ATP_ECC_Error = TST_ATP_ECC_Error+TST_ATP_Error;
   
    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
    if (TST_ATP_ECC_Error != TESTPASS)
	    return 	TST_ATP_ECC_Error;
    #endif

    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_ECDSA_IntegratedSignVerify (TST_KeyGeneration_TestStatus);
    TST_ATP_ECC_Error = TST_ATP_ECC_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	if (TST_ATP_ECC_Error != TESTPASS)
        return 	TST_ATP_ECC_Error;
    #endif
    

    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_DH (TST_KeyGeneration_TestStatus);
    TST_ATP_ECC_Error = TST_ATP_ECC_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	if (TST_ATP_ECC_Error != TESTPASS)
	    return 	TST_ATP_ECC_Error;
    #endif

    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_ElGamal_EncDec (TST_KeyGeneration_TestStatus);
    TST_ATP_ECC_Error = TST_ATP_ECC_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	if (TST_ATP_ECC_Error != TESTPASS)
	    return 	TST_ATP_ECC_Error;
    #endif
    
    TST_ATP_Error = CRYS_ExtApp_ATP_ECC_ImportExportKeyPair (TST_KeyGeneration_TestStatus);
    TST_ATP_ECC_Error = TST_ATP_ECC_Error+TST_ATP_Error;

    #if CRYS_ATP_TST_EXIT_SYS_TST_ON_ERROR
	if (TST_ATP_ECC_Error != TESTPASS)
	    return 	TST_ATP_ECC_Error;
    #endif
    
	/*Check if all tests pass*/
	if (TST_ATP_ECC_Error != TESTPASS)
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!! ONE OR MORE OF THE ECC TESTS FAILED  !!!!!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\n"));
        }
        else
        {
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n \n**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"*** ALL OF THE ECC Acceptance TESTS PASS   :-)     ***\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));
            if (TST_KeyGeneration_TestStatus  == TST_EXTERNAL_KEYPAIR)
                ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!!!!!!!!!!!!!! WITHOUT INTERNAL KEY GENERATION !!!!!!!!!!!!!!!!!\n"));
            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"**********************\n"));								
		}
		return TST_ATP_ECC_Error;
}



